<?php

namespace MoveOn\Subscription\Modules\Gateway;


use Attribute;
use MoveOn\Subscription\Contracts\GatewayClientStripe;
use MoveOn\Subscription\Contracts\GatewayManagerStripeCustomerContract;
use MoveOn\Subscription\Contracts\GatewayManagerStripeInvoiceContract;
use MoveOn\Subscription\Contracts\GatewayManagerStripeSessionContract;
use MoveOn\Subscription\Contracts\GatewayManagerStripeSubscriptionItemContract;

#[Attribute]
class ClientStripe implements GatewayClientStripe
{

    protected \Stripe\StripeClient $stripe;

    public function __construct(string $secret)
    {
        $this->stripe = new \Stripe\StripeClient($secret);
    }

    public function product(): StripeProductManager
    {
        return new StripeProductManager($this->stripe);
    }

    public function plan(): StripePlanManager
    {
        return new StripePlanManager($this->stripe);
    }

    public function customer(): GatewayManagerStripeCustomerContract
    {
        return new StripeCustomerManager($this->stripe);
    }

    public function subscription(): StripeSubscriptionManager
    {
        return new StripeSubscriptionManager($this->stripe);
    }

    public function subscriptionItem(): GatewayManagerStripeSubscriptionItemContract
    {
        return new StripeSubscriptionItemManager($this->stripe);
    }

    public function session(): GatewayManagerStripeSessionContract
    {
        return new StripeSessionManager($this->stripe);
    }

    public function invoice(): GatewayManagerStripeInvoiceContract
    {
        return new StripeInvoiceManager($this->stripe);
    }
}