<?php

namespace MoveOn\Subscription\Modules\Gateway;

use MoveOn\Subscription\Contracts\GatewayManagerStripeCustomerContract;
use Stripe\StripeClient;

class StripeCustomerManager implements GatewayManagerStripeCustomerContract
{
    private StripeClient $stripe;

    public function __construct(StripeClient $stripe)
    {
        $this->stripe = $stripe;
    }

    public function createCustomer(array $params = [])
    {
        return $this->stripe->customers->create($params);
    }

}