<?php

namespace MoveOn\Subscription\Modules\Gateway;

use Illuminate\Support\Arr;
use MoveOn\Subscription\Contracts\GatewayManagerStripeInvoiceContract;
use MoveOn\Subscription\Contracts\GatewayManagerStripeSessionContract;
use MoveOn\Subscription\Contracts\GatewayManagerStripeSubscriptionItemContract;
use MoveOn\Subscription\Contracts\StripeSubscriptionManagerContract;
use MoveOn\Subscription\Requests\InvoiceUpdateDTORequest;
use MoveOn\Subscription\Requests\Modules\Stripe\StripeInvoiceUpdateDTORequest;
use MoveOn\Subscription\Requests\Modules\Stripe\StripeSubscriptionStoreDTORequest;
use MoveOn\Subscription\Response\Gateway\Stripe\StripeErrorResponse;
use Stripe\Exception\ApiErrorException as ApiErrorExceptionAlias;
use Stripe\Invoice;
use Stripe\StripeClient;
use Stripe\Subscription;
use Stripe\UsageRecord;

class StripeInvoiceManager implements GatewayManagerStripeInvoiceContract
{
    private StripeClient $stripe;

    public function __construct(StripeClient $stripe)
    {
        $this->stripe = $stripe;
    }

    /**
     * @throws ApiErrorExceptionAlias
     */
    public function retrieve(string $invoiceId): \Stripe\Invoice
    {
        return $this->stripe->invoices->retrieve($invoiceId);
    }

    /**
     * @param string $invoiceId
     * @param StripeInvoiceUpdateDTORequest $form
     * @return Invoice
     * @throws StripeErrorResponse
     */
    public function update(string $invoiceId, StripeInvoiceUpdateDTORequest $form): \Stripe\Invoice
    {
        try{
            $form = Arr::whereNotNull($form->pureArray(true));
            return $this->stripe->invoices->update($invoiceId, $form);
        }catch (\Exception $exception){
            throw new StripeErrorResponse(get_class($this) . ":updateInvoice:" , $exception, 500);
        }
    }
}