<?php

namespace MoveOn\Subscription\Modules\Gateway;

use MoveOn\Subscription\Contracts\GatewayManagerStripePlanContract;
use Stripe\Plan;
use Stripe\StripeClient;

class StripePlanManager implements GatewayManagerStripePlanContract
{
    private StripeClient $stripe;

    public function __construct(StripeClient $stripe)
    {
        $this->stripe = $stripe;
    }

    public function createPlan(array $form): Plan
    {
        return $this->stripe->plans->create($form);
    }

    public function updatePlan(string $planId, array $payload): Plan
    {
        return $this->stripe->plans->update(
            $planId,
            $payload
        );
    }

}