<?php

namespace MoveOn\Subscription\Modules;

use MoveOn\Common\Traits\Makeable;
use MoveOn\Subscription\Enums\FeeType;
use MoveOn\Subscription\Models\Discount;
use MoveOn\Subscription\Models\Plan;

class PlanDiscountModule
{
    use Makeable;

    public function gePlanAmount(Plan $plan, Discount $discount = null): array
    {
        $planUnitAmount = $plan->unit_amount;
        $totalDiscountAmount = 0;

        if(!empty($discount)){
            if ($discount->amount_type == FeeType::FIXED) {
                $totalDiscountAmount = $discount->amount;
            }

            if($discount->amount_type == FeeType::PERCENTAGE){
                $totalDiscountAmount = min($planUnitAmount * ($discount->amount / 100), $discount->maximum_discount_amount);
            }
        }

        $totalAmount = $planUnitAmount - $totalDiscountAmount;

        return [$planUnitAmount, $totalDiscountAmount, $totalAmount];
    }
}