<?php

namespace MoveOn\Subscription;


use Illuminate\Contracts\Foundation\Application;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\ServiceProvider;
use MoveOn\Subscription\Contracts\GatewayClientPaypal;
use MoveOn\Subscription\Contracts\GatewayClientStripe;
use MoveOn\Subscription\Modules\Gateway\ClientPaypal;
use MoveOn\Subscription\Modules\Gateway\ClientStripe;

class MoveOnSubscriptionProvider extends ServiceProvider
{
    public function boot()
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../config/subscription.php' => config_path('subscription.php'),
            ], 'mv-subscription-config');

            $this->publishes([
                __DIR__.'/../database/migrations/' => database_path('migrations')
            ], 'mv-subscription-migration');
        }

        $this->loadMigrationsFrom(__DIR__.'/../database/migrations');
        $this->loadRoutesFrom(__DIR__.'/../routes/web.php');


        $this->app->bind(GatewayClientStripe::class, function ($app) {
            return new ClientStripe(config("subscription.stripe.client_secret"));
        });

        $this->app->bind(GatewayClientPaypal::class, function ($app) {
            return new ClientPaypal(config("subscription.paypal.client_id"), config("subscription.paypal.client_secret"));
        });
    }

    public function register()
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/subscription.php', 'subscription');
    }
}