<?php

namespace MoveOn\Subscription\QueryFilters;

use MoveOn\Common\Modules\QueryFilter;
use MoveOn\Subscription\Enums\FeeType;
use MoveOn\Subscription\Enums\GatewayType;

class DiscountUserFilter extends QueryFilter
{

    public static function filterableDetails(): array
    {
        return array_merge( [
            "id" => [
                "type" => "integer",
            ],

            "discount_id" => [
                "type" => "integer",
            ],

            "user_id" => [
                "type" => "integer",
            ],

            "gateway_id" => [
                "type" => "integer",
            ],

            "plan_id" => [
                "type" => "integer",
            ],

            "is_active" => [
                "type" => "boolean",
            ]
        ], parent::filterableDetails());
    }


    protected function id($query, $param)
    {
        return $query->where("id", "$param");
    }

    protected function discountId($query, $param)
    {
        return $query->where("discount_id", $param);
    }

    protected function userId($query, $param)
    {
        return $query->where("owner_id", $param);
    }

    protected function gatewayId($query, $param)
    {
        return $query->where("gateway_id", $param);
    }

    protected function planId($query, $param)
    {
        return $query->where("plan_id", $param);
    }

    protected function isActive($query, $param)
    {
        return $query->where("is_active", $param);
    }

}