<?php

namespace MoveOn\Subscription\Requests\Modules\Paypal\Plan;

use MoveOn\Subscription\Collection\Modules\Paypal\PaypalPlanBillingCycleCollection;
use MoveOn\Subscription\Enums\Gateway\Paypal\PaypalPlanStatus;
use MoveOn\Subscription\Requests\BaseRequest;
use MoveOn\Subscription\Requests\Modules\Paypal\PaypalPaymentPreference;

class PaypalPlanStore extends BaseRequest
{
    public function __construct(
        public string $name,
        public PaypalPlanBillingCycleCollection $billing_cycles,
        public PaypalPaymentPreference $payment_preferences,
        public string $product_id,
        public ?PaypalPlanStatus $status = null,
        public ?bool $quantity_supported = true,
        public ?string $description = null,
    ) {
        $this->status = PaypalPlanStatus::ACTIVE;
    }
}