<?php

namespace MoveOn\Subscription\Requests;

class ProductStoreDTORequest extends BaseRequest
{
    /**
     * @param string $name
     * @param string|null $category
     * @param string|null $description
     * @param string|null $image_url
     * @param string|null $home_url
     * @param string|null $type
     * @throws \Exception
     */
    public function __construct(
        public string $name,
        public ?string $category = "SOFTWARE",
        public ?string $description = null,
        public ?string $image_url = null,
        public ?string $home_url = null,
        public ?string $type = "SERVICE",
    ) {
        if(!empty($this->image_url) && !filter_var($this->image_url, FILTER_VALIDATE_URL)) throw new \Exception("ProductStoreDTORequest:Give valid home url", 422);
        if(!empty($this->home_url) && !filter_var($this->home_url, FILTER_VALIDATE_URL)) throw new \Exception("ProductStoreDTORequest:Give valid home url", 422);
    }
}