<?php

namespace MoveOn\Subscription\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Model;
use MoveOn\Subscription\Enums\DiscountDuration;
use MoveOn\Subscription\Enums\FeeType;
use MoveOn\Subscription\Models\Discount;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<Model>
 */
class DiscountFactory extends Factory
{
    protected $model = Discount::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            "name"                    => $this->faker->name,
            "coupon_code"             => rand(1, 2000),
            "currency"                => $this->faker->randomElement($this->getCurrencies()),
            "duration"                => $this->faker->randomElement(DiscountDuration::values()),
            "duration_in_months"      => $this->faker->randomDigitNot(0),
            "amount_type"             => $this->faker->randomElement(FeeType::values()),
            "gateway_coupon_id"       => $this->faker->shuffleString,
            "amount"                  => $this->faker->randomDigitNot(0),
            "maximum_discount_amount" => $this->faker->randomDigit(),
            "is_active"               => $this->faker->boolean,
            "expired_at"              => $this->faker->randomElement([now()->addDays(5)->format("Y-m-d H:i:s"), null]),
        ];
    }

    private function getCurrencies()
    {
        return [
            "usd",
        ];
    }
}


