<?php

namespace MoveOn\Subscription\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use MoveOn\Subscription\Models\PaymentGateway;
use MoveOn\Subscription\Models\Product;
use MoveOn\Subscription\Service\ProductService;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\MoveOn\Subscription\Models\Product>
 */
class ProductFactory extends Factory
{
    protected $model = Product::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $name        = $this->faker->text(6);
        $description = $this->faker->text(20);
        $gateway     = PaymentGateway::inRandomOrder()->first();

        return [
            "name"               => $name,
            "description"        => $description,
            "image_url"          => $this->faker->url(),
            "home_url"           => $this->faker->url(),
            "gateway_id"         => optional($gateway)->id,
            "gateway_product_id" => mt_rand(1111, 999999),
            "category"           => "SOFTWARE",
        ];
    }
}
