<?php

namespace MoveOn\Subscription\Database\Seeders;

use Illuminate\Database\Seeder;
use MoveOn\Subscription\Database\Factories\PaymentGatewayFactory;
use MoveOn\Subscription\Enums\GatewaySlug;
use MoveOn\Subscription\Enums\GatewayType;
use MoveOn\Subscription\Models\PaymentGateway;
use MoveOn\Subscription\Requests\PaymentGatewayRequest;
use MoveOn\Subscription\Service\PaymentGatewayService;

class PaymentGatewaySeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if ( ! PaymentGateway::where("slug", GatewaySlug::PAYPAL())->first()) {
            $slug        = GatewaySlug::PAYPAL();
            $gatewayType = GatewayType::REGULAR();
            $form        = PaymentGatewayFactory::new()->make(
                [
                    "name"         => "Paypal",
                    "slug"         => $slug,
                    "gateway_type" => $gatewayType,
                ]
            );

            PaymentGatewayService::make()->create(
                (new PaymentGatewayRequest(
                    "Paypal",
                    $slug,
                    $gatewayType,
                    $form->fee_type,
                    $form->fee,
                    $form->logo,
                    $form->url
                ))
            );
        }

        if ( ! PaymentGateway::where("slug", GatewaySlug::STRIPE())->first()) {
            $slug        = GatewaySlug::STRIPE();
            $gatewayType = GatewayType::REGULAR();
            $form        = PaymentGatewayFactory::new()->make(
                [
                    "name"         => "Stripe",
                    "slug"         => $slug,
                    "gateway_type" => $gatewayType,
                ]
            );
            PaymentGatewayService::make()->create(
                (new PaymentGatewayRequest(
                    "Stripe",
                    $slug,
                    $gatewayType,
                    $form->fee_type,
                    $form->fee,
                    $form->logo,
                    $form->url
                ))
            );
        }
    }
}
