<?php

namespace MoveOn\Subscription\Contracts;

use MoveOn\Subscription\Requests\Modules\Paypal\Subscription\PaypalSubscriptionStoreDTORequest;
use MoveOn\Subscription\Response\Gateway\Paypal\PaypalErrorResponse;
use MoveOn\Subscription\Response\Gateway\Paypal\PaypalSubscriptionResponse;

interface PaypalSubscriptionManagerContract
{
    /**
     * @param PaypalSubscriptionStoreDTORequest $request
     * @throws PaypalErrorResponse
     */
    public function createSubscription(PaypalSubscriptionStoreDTORequest $request): PaypalSubscriptionResponse;

    /**
     * @param string $subscriptionId
     * @return PaypalSubscriptionResponse
     */
    public function detailsSubscription(string $subscriptionId): PaypalSubscriptionResponse;

    /**
     * @param string $subscriptionId
     * @return bool
     */
    public function cancelSubscription(string $subscriptionId): bool;
}