<?php

namespace MoveOn\Subscription\Contracts;

use Illuminate\Http\Request;
use MoveOn\Subscription\Models\PaymentGateway;
use MoveOn\Subscription\Requests\PaymentGatewayRequest;

interface ServiceContractPaymentGateway
{
    public function list(Request $request): array;

    public function retrieve(int $paymentGateway): PaymentGateway;

    public function create(PaymentGatewayRequest $form): PaymentGateway;

    public function update(PaymentGateway $paymentGateway, PaymentGatewayRequest $form): bool;

    public function delete(PaymentGateway $paymentGateway): bool;

    public function enable(PaymentGateway $paymentGateway): bool;

    public function disable(PaymentGateway $paymentGateway): bool;
}
