<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use MoveOn\Common\Traits\Filterable;
use Zoha\Metable;

class GatewayAssociatedCustomer extends Model
{
    use HasFactory;
    use Metable;
    use Filterable;
    use SoftDeletes;

    protected $metaTable;
    protected $table;

    protected $guarded = ['id'];

    protected $casts = [
        "is_active" => "boolean"
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->metaTable = config("subscription.subscription_table_prefix") . "_meta";
        $this->table = config("subscription.subscription_table_prefix") . "_gateway_customers";
    }

    public function owner()
    {
        return $this->morphTo("ownerable");
    }

    public function gateway()
    {
        return $this->belongsTo(PaymentGateway::class, "gateway_id");
    }
}
