<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use MoveOn\Common\Traits\Filterable;
use Zoha\Metable;

class PaymentGateway extends Model
{
    use HasFactory;
    use Metable;
    use SoftDeletes;
    use Filterable;

    protected $guarded = ['id'];
    protected $metaTable;
    protected $table;

    protected $casts = [
        "fee"       => "double",
        "is_active" => "boolean",
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->metaTable = config('subscription.subscription_table_prefix') . '_meta';
        $this->table     = config('subscription.subscription_table_prefix') . '_payment_gateways';
    }

    public function products()
    {
        return $this->hasMany(Product::class, 'gateway_id', 'id');
    }

    public function subscriptions()
    {
        return $this->hasMany(Subscription::class, "gateway_id");
    }

    public function plans()
    {
        return $this->hasMany(Plan::class, "gateway_id");
    }

    public function customers()
    {
        return $this->hasMany(GatewayAssociatedCustomer::class, "gateway_id");
    }
}