<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use MoveOn\Common\Traits\Filterable;
use Zoha\Metable;

class Product extends Model
{
    use HasFactory;
    use Metable;
    use SoftDeletes;
    use Filterable;

    protected $metaTable;

    protected $guarded = ['id'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->metaTable = config('subscription.subscription_table_prefix') . '_meta';
        $this->table = config('subscription.subscription_table_prefix') . '_products';
    }

    public function gateway()
    {
        return $this->belongsTo(PaymentGateway::class, 'gateway_id', 'id');
    }

    public function plans()
    {
        return $this->hasMany(Plan::class, "product_id");
    }

    public function subscriptions()
    {
        return $this->hasMany(Subscription::class, "product_id");
    }
}
