<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use MoveOn\Common\Traits\Filterable;

class StripeInvoice extends Model
{
    use Filterable;
    use HasFactory;

    protected $table;

    protected $guarded = ['id'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->table = config("subscription.subscription_table_prefix") . "_stripe_invoices";
    }

    public function invoice(): MorphOne
    {
        return $this->morphOne(Invoice::class, 'invoice_of');
    }
}
