<?php

namespace MoveOn\Subscription\Modules\Webhook;

use MoveOn\Subscription\Contracts\WebhookContract;
use MoveOn\Subscription\Contracts\WebhookProcessorContract;
use MoveOn\Subscription\Modules\Webhook\Paypal\PaypalWebhook;
use MoveOn\Subscription\Modules\Webhook\Stripe\StripeWebhook;

class Webhook implements WebhookContract
{
    /**
     * @throws \Exception
     */
    public function stripe(string $secret): WebhookProcessorContract
    {
        if(empty($secret)) throw new \Exception("Give valid Stripe secret");
        return new StripeWebhook($secret);
    }

    public function paypal(string $client, string $secret): WebhookProcessorContract
    {
        if(empty($client) || empty($secret)) throw new \Exception("Give valid paypal token");
        return new PaypalWebhook($client, $secret);
    }
}