<?php

namespace MoveOn\Subscription\QueryFilters;

use MoveOn\Common\Modules\QueryFilter;

class DiscountUsageHistoryFilter extends QueryFilter
{

    public static function filterableDetails(): array
    {
        return array_merge( [
            "id"         => [
                "type" => "integer",
            ],

            "user_id"   => [
                "type" => "integer",
            ],

            "subscription_id" => [
                "type" => "integer",
            ],

            "discount_id" => [
                "type" => "integer",
            ]
        ], parent::filterableDetails());
    }


    protected function userId($query, $param)
    {
        return $query->where("owner_id", $param);
    }

    protected function discountId($query, $param)
    {
        return $query->where("discount_id", $param);
    }

    protected function subscriptionId($query, $param)
    {
        return $query->where("subscription_id", $param);
    }

}