<?php

namespace MoveOn\Subscription\QueryFilters;

use MoveOn\Common\Modules\QueryFilter;
use MoveOn\Subscription\Enums\IntervalUnit;
use MoveOn\Subscription\Enums\PricingScheme;
use MoveOn\Subscription\Enums\QuantitySource;
use MoveOn\Subscription\Enums\UsageType;

class PlanFilter extends QueryFilter
{

    public static function filterableDetails(): array
    {
        return array_merge( [
            "id" => [
                "type" => "integer",
            ],

            "gateway_id" => [
                "type" => "integer",
            ],

            "product_id" => [
                "type" => "integer",
            ],

            "gateway_plan_id" => [
                "type" => "string",
            ],

            "currency" => [
                "type" => "string",
            ],

            "name" => [
                "type" => "string",
            ],

            "unit_amount" => [
                "type" => "range",
            ],

            "quantity_source" => [
                "type"   => "select",
                "values" => QuantitySource::pairedValues(),
            ],

            "default_quantity" => [
                "type" => "range",
            ],

            "usage_type" => [
                "type"   => "select",
                "values" => UsageType::pairedValues(),
            ],

            "interval_unit" => [
                "type"   => "select",
                "values" => IntervalUnit::pairedValues(),
            ],

            "interval_count" => [
                "type"   => "integer",
            ],

            "pricing_scheme" => [
                "type"   => "select",
                "values" => PricingScheme::pairedValues(),
            ],

            "trial_period_days" => [
                "type" => "range",
            ],

            "system_usage_charge" => [
                "type" => "range",
            ],

            "is_active" => [
                "type"   => "boolean",
            ]
        ], parent::filterableDetails());
    }

    public function gatewayId($query, $param)
    {
        return $query->where("gateway_id", "$param");
    }

    public function productId($query, $param)
    {
        return $query->where("product_id", "$param");
    }

    public function gatewayPlanId($query, $param)
    {
        return $query->where("gateway_plan_id", "$param");
    }

    public function currency($query, $param)
    {
        return $query->where("currency", "$param");
    }

    public function name($query, $param)
    {
        return $query->where("name", "like", "%$param%");
    }

    public function unitAmount($query, $param)
    {
        if (is_array($param) && count($param) == 2) {
            return $query->whereBetween("unit_amount", $param);
        }

        return $query;
    }

    public function quantitySource($query, $param)
    {
        return $query->where("quantity_source", $param);
    }

    public function defaultQuantity($query, $param)
    {
        if (is_array($param) && count($param) == 2) {
            return $query->whereBetween("default_quantity", $param);
        }

        return $query;
    }

    public function usageType($query, $param)
    {
        return $query->where("usage_type", $param);
    }

    public function intervalUnit($query, $param)
    {
        return $query->where("interval_unit", $param);
    }

    public function pricingScheme($query, $param)
    {
        return $query->where("pricing_scheme", $param);
    }

    public function trialPeriodDays($query, $param)
    {
        if (is_array($param) && count($param) == 2) {
            return $query->whereBetween("trial_period_days", $param);
        }

        return $query;
    }

    public function systemUsageCharge($query, $param)
    {
        if (is_array($param) && count($param) == 2) {
            return $query->whereBetween("system_usage_charge", $param);
        }

        return $query;
    }

    public function isActive($query, $param)
    {
        return $query->where("is_active", $param);
    }
}