<?php

namespace MoveOn\Subscription\Requests\Modules\Paypal;

use MoveOn\Subscription\Requests\BaseRequest;

class PaypalPaymentPreference extends BaseRequest
{
    /**
     * @param bool $auto_bill_outstanding
     * @param string $setup_fee_failure_action
     * @param PaypalMoney|null $setup_fee
     */
    public function __construct(
        public bool $auto_bill_outstanding,
        public string $setup_fee_failure_action = "CONTINUE",
        public int $payment_failure_threshold  = 5,
        public ?PaypalMoney $setup_fee = null,
    ) {
    }
}