<?php

namespace MoveOn\Subscription\Requests\Modules\Stripe;

use MoveOn\Subscription\Collection\Modules\Stripe\StripeSubscriptionPaymentMethodSettingCollection;
use MoveOn\Subscription\Collection\Modules\Stripe\StripeSubscriptionStoreItemCollection;
use MoveOn\Subscription\Enums\Gateway\Stripe\StripeProrationBehaviourEnum;
use MoveOn\Subscription\Enums\Gateway\Stripe\StripeSubscriptionPaymentBehaviourEnum;
use MoveOn\Subscription\Requests\BaseRequest;

class StripeSubscriptionUpdateDTORequest extends BaseRequest
{
    public function __construct(
        public string                       $newPlanId,
        public string                       $currentSubscriptionItemId,
        public bool                         $cancelAtPeriodEnd = false,
        public StripeProrationBehaviourEnum $prorationBehaviour = StripeProrationBehaviourEnum::ALWAYS_INVOICE,
    ){}
}