<?php

namespace MoveOn\Subscription\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use MoveOn\Subscription\Models\DiscountUser;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\MoveOn\Subscription\Models\DiscountUser>
 */
class DiscountUserFactory extends Factory
{
    protected $model = DiscountUser::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            "discount_id" => rand(1, 100),
            "owner_type"  => 'user',
            "owner_id"    => rand(1, 100),
            "gateway_id"  => rand(1, 100),
            "plan_id"     => rand(1, 100),
        ];
    }
}
