<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use MoveOn\Subscription\Enums\Gateway\Stripe\StripeInvoiceStatusTypeEnum;
use MoveOn\Subscription\Models\StripeInvoice;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create((new StripeInvoice())->getTable(), function (Blueprint $table) {
            $table->id();
            $table->string('gateway_invoice_id');
            $table->decimal('amount_due');
            $table->decimal('amount_paid');
            $table->decimal('amount_remaining');
            $table->string('billing_reason');
            $table->string('currency');
            $table->string('status')->default(StripeInvoiceStatusTypeEnum::OPEN());
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists((new StripeInvoice())->getTable());
    }
};
