<?php

namespace MoveOn\Subscription\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use MoveOn\Subscription\Collection\Modules\Paypal\PlanTierCollection;
use MoveOn\Subscription\Database\Factories\PlanFactory;
use MoveOn\Subscription\Enums\GatewaySlug;
use MoveOn\Subscription\Enums\IntervalUnit;
use MoveOn\Subscription\Enums\PricingScheme;
use MoveOn\Subscription\Enums\QuantitySource;
use MoveOn\Subscription\Enums\UsageType;
use MoveOn\Subscription\Models\PaymentGateway;
use MoveOn\Subscription\Requests\PlanCreateDTORequest;
use MoveOn\Subscription\Requests\PlanTierDTORequest;
use MoveOn\Subscription\Service\PlanService;

class PlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $gateway = PaymentGateway::where(
            "slug",
            GatewaySlug::STRIPE()
        )->inRandomOrder()->first();
        $product = $gateway->products()->inRandomOrder()->first();
        $plan    = PlanFactory::new()->make(
            [
                "gateway_id" => $gateway->id,
                "product_id" => $product->id,
                "usage_type" => UsageType::METERED,
                "pricing_scheme" => PricingScheme::TIERED,
                "quantity_source" => QuantitySource::USER_INPUT,
                "trial_period_days" => 0,
                "system_usage_charge" => 0,
            ]
        );

        PlanService::make()->createPlan(
            new PlanCreateDTORequest(
                $product,
                $plan->currency,
                $plan->name,
                (int)$plan->unit_amount,
                IntervalUnit::from(Str::lower($plan->interval_unit)),
                (int)$plan->interval_count,
                $plan->usage_type,
                $plan->pricing_scheme,
                $plan->quantity_source,
                $plan->trial_period_days,
                $plan->system_usage_charge,
                PlanTierCollection::make()
                    ->add(
                        new PlanTierDTORequest(1, 20, 16)
                    )
                    ->add(
                        new PlanTierDTORequest(21, null, 20)
                    )
            )
        );


        $gateway = PaymentGateway::where(
            "slug",
            GatewaySlug::PAYPAL()
        )->inRandomOrder()->first();
        $product = $gateway->products()->inRandomOrder()->first();
        $plan    = PlanFactory::new()->make(
            [
                "gateway_id" => $gateway->id,
                "product_id" => $product->id,
            ]
        );

        PlanService::make()->createPlan(
            new PlanCreateDTORequest(
                $product,
                $plan->currency,
                $plan->name,
                $plan->unit_amount,
                IntervalUnit::from(Str::upper($plan->interval_unit)),
                $plan->interval_count,
                $plan->usage_type,
                $plan->pricing_scheme,
                $plan->quantity_source,
                $plan->trial_period_days,
                $plan->system_usage_charge,
                PlanTierCollection::make()
                    ->add(
                        new PlanTierDTORequest(1, 20, 16)
                    )
                    ->add(
                        new PlanTierDTORequest(21, null, 20)
                    )
            )
        );
    }
}
