<?php

namespace MoveOn\Subscription\Database\Seeders;

use Illuminate\Database\Seeder;
use MoveOn\Subscription\Database\Factories\ProductFactory;
use MoveOn\Subscription\Enums\GatewaySlug;
use MoveOn\Subscription\Models\PaymentGateway;
use MoveOn\Subscription\Models\Product;
use MoveOn\Subscription\Requests\ProductStoreDTORequest;
use MoveOn\Subscription\Service\ProductService;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $gateway = PaymentGateway::where("slug", GatewaySlug::STRIPE())->first();
        $form    = ProductFactory::new()->make(
            [
                "gateway_id" => $gateway->id,
            ]
        );
        ProductService::make()->createProduct(
            $gateway,
            (new ProductStoreDTORequest(
                $form->name,
                "SOFTWARE",
                $form->description,
                $form->image_url,
                $form->home_url,
            ))
        );

        $gateway = PaymentGateway::where("slug", GatewaySlug::PAYPAL())->first();
        $form    = ProductFactory::new()->make(
            [
                "gateway_id" => $gateway->id,
            ]
        );
        ProductService::make()->createProduct(
            $gateway,
            (new ProductStoreDTORequest(
                $form->name,
                "SOFTWARE",
                $form->description,
                $form->image_url,
                $form->home_url,
            ))
        );
    }
}
