<?php

namespace MoveOn\Subscription\Contracts;

use MoveOn\Subscription\Modules\Gateway\StripePlanManager;
use MoveOn\Subscription\Modules\Gateway\StripeProductManager;
use MoveOn\Subscription\Requests\Modules\Stripe\StripeInvoiceUpdateDTORequest;
use Stripe\Invoice;
use Stripe\UsageRecord;

interface GatewayManagerStripeInvoiceContract
{
    /**
     * @param string $invoiceId
     * @return mixed
     */
    public function retrieve(string $invoiceId): \Stripe\Invoice;

    /**
     * @param string $invoiceId
     * @param StripeInvoiceUpdateDTORequest $form
     * @return Invoice
     */
    public function update(string $invoiceId, StripeInvoiceUpdateDTORequest $form): \Stripe\Invoice;
}