<?php

namespace MoveOn\Subscription\Contracts;

use MoveOn\Subscription\Collection\Modules\Paypal\PaypalProductUpdateCollection;
use MoveOn\Subscription\Requests\Modules\Paypal\PaypalListRequest;
use MoveOn\Subscription\Requests\Modules\Paypal\Product\PaypalProductStoreDTORequest;
use MoveOn\Subscription\Response\Gateway\Paypal\Product\PaypalProductResponse;

interface PaypalProductManagerContract
{
    public function listProduct(PaypalListRequest $request): array;

    public function createProduct(PaypalProductStoreDTORequest $request): PaypalProductResponse;

    public function updateProduct(string $productId, PaypalProductUpdateCollection $collection): bool;

    public function detailsProduct(string $productId): PaypalProductResponse;
}