<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use MoveOn\Common\Traits\Filterable;
use Zoha\Metable;

class DiscountUser extends Model
{
    use HasFactory;
    use Metable;
    use SoftDeletes;
    use Filterable;

    protected $metaTable;
    protected $table;

    protected $guarded = ['id'];

    protected $casts = [
        "is_active" => "boolean",
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->table = config("subscription.subscription_table_prefix") . "_discount_users";
    }

    public function discount()
    {
        return $this->belongsTo(Discount::class, "discount_id");
    }

    public function user()
    {
        return $this->morphTo("owner");
    }

    public function gateway()
    {
        return $this->belongsTo(PaymentGateway::class, "gateway_id");
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class, "plan_id");
    }
}
