<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use MoveOn\Common\Traits\Filterable;

class Invoice extends Model
{
    use HasFactory;
    use Filterable;

    protected $table;

    protected $guarded = ['id'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->table = config("subscription.subscription_table_prefix") . "_invoices";
    }

    public function owner(): MorphTo
    {
        return $this->morphTo('owner');
    }

    public function subscription(): BelongsTo
    {
        return $this->belongsTo(Subscription::class);
    }

    public function detail(): MorphTo
    {
        return $this->morphTo(null, 'invoice_of_type', 'invoice_of_id');
    }
}
