<?php

namespace MoveOn\Subscription\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use MoveOn\Common\Traits\Filterable;
use Zoha\Metable;

class Subscription extends Model
{
    use Metable;
    use Filterable;
    use SoftDeletes;

    protected $metaTable;
    protected $table;

    protected $guarded = ['id'];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->metaTable = config('subscription.subscription_table_prefix') . '_meta';
        $this->table = config('subscription.subscription_table_prefix') . '_subscriptions';
    }

    public function gateway()
    {
        return $this->belongsTo(PaymentGateway::class, "gateway_id");
    }

    public function usageHistories()
    {
        return $this->hasMany(DiscountUsageHistory::class, "subscription_id");
    }

    public function owner()
    {
        return $this->morphTo("owner");
    }

    public function discount()
    {
        return $this->belongsTo(Discount::class, "discount_id");
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class, "plan_id");
    }

    public function subscriptionItems()
    {
        return $this->hasMany(SubscriptionItem::class, "subscription_id");
    }
}