<?php

namespace MoveOn\Subscription\Modules\Gateway;

use MoveOn\Subscription\Contracts\GatewayClientPaypal;
use MoveOn\Subscription\Contracts\PaypalPlanManagerContract;
use MoveOn\Subscription\Contracts\PaypalProductManagerContract;
use MoveOn\Subscription\Contracts\PaypalSubscriptionManagerContract;

class ClientPaypal implements GatewayClientPaypal
{
    protected string $clientId;
    protected string $secret;

    public function __construct(string $clientId, string $secret)
    {
        $this->clientId = $clientId;
        $this->secret   = $secret;
    }

    public function product(): PaypalProductManagerContract
    {
        return new PaypalProductManager($this->clientId, $this->secret);
    }

    public function plan(): PaypalPlanManagerContract
    {
        return new PaypalPlanManager($this->clientId, $this->secret);
    }

    public function subscription(): PaypalSubscriptionManagerContract
    {
        return new PaypalSubscriptionManager($this->clientId, $this->secret);
    }
}