<?php

namespace MoveOn\Subscription\Modules\Gateway;

use MoveOn\Subscription\Contracts\GatewayManagerStripePaymentMethodContract;
use Stripe\Exception\ApiErrorException;
use Stripe\PaymentMethod;
use Stripe\StripeClient;

class StripPaymentMethodManager implements GatewayManagerStripePaymentMethodContract
{
    private StripeClient $stripe;

    public function __construct(StripeClient $stripe)
    {
        $this->stripe = $stripe;
    }

    /**
     * @throws ApiErrorException
     */
    public function attachPaymentMethod(array $form): PaymentMethod
    {
        return $this->stripe->paymentMethods->attach($form['payment_method'], [
            'customer' => $form['customer'],
        ]);
    }

}