<?php

namespace MoveOn\Subscription\QueryFilters;

use MoveOn\Common\Modules\QueryFilter;
use MoveOn\Subscription\Enums\DiscountDuration;
use MoveOn\Subscription\Enums\FeeType;
use MoveOn\Subscription\Enums\GatewayType;

class DiscountFilter extends QueryFilter
{

    public static function filterableDetails(): array
    {
        return array_merge( [
            "id" => [
                "type" => "integer",
            ],

            "name" => [
                "type" => "string",
            ],

            "coupon_code" => [
                "type" => "string",
            ],

            "currency" => [
                "type" => "string",
            ],

            "duration" => [
                "type" => "select",
                "values" => DiscountDuration::pairedValues(),
            ],

            "duration_in_months" => [
                "type" => "integer",
            ],

            "amount_type" => [
                "type" => "select",
                "values" => FeeType::pairedValues(),
            ],

            "gateway_coupon_id" => [
                "type" => "string",
            ],

            "amount" => [
                "type" => "integer",
            ],

            "maximum_discount_amount" => [
                "type" => "range",
            ]
        ], parent::filterableDetails());
    }

    protected function name($query, $param)
    {
        return $query->where("name", "like", "%$param%");
    }

    protected function couponCode($query, $param)
    {
        return $query->where("coupon_code", $param);
    }

    protected function currency($query, $param)
    {
        return $query->where("currency", $param);
    }

    protected function duration($query, $param)
    {
        return $query->where("duration", $param);
    }

    protected function durationInMonths($query, $param)
    {
        return $query->where("duration_in_months", $param);
    }

    protected function amountType($query, $param)
    {
        return $query->where("amount_type", $param);
    }

    protected function amount($query, $param)
    {
        return $query->where("amount", $param);
    }

    protected function gatewayCouponId($query, $param)
    {
        return $query->where("gateway_coupon_id", $param);
    }

    protected function maximumDiscountAmount($query, $param)
    {
        if(is_array($param) && count($param) == 2){
            return $query->whereBetween("maximum_discount_amount", $param);
        }

        return $query;
    }

}