<?php

namespace MoveOn\Subscription\QueryFilters;

use MoveOn\Common\Modules\QueryFilter;

class GatewayAssociatedCustomerFilter extends QueryFilter
{

    public static function filterableDetails(): array
    {
        return array_merge( [
            "id"         => [
                "type" => "integer",
            ],

            "ownerable_id"   => [
                "type" => "integer",
            ],

            "ownerable_type"   => [
                "type" => "string",
            ],

            "gateway_id" => [
                "type" => "integer",
            ],

            "gateway_customer_id" => [
                "type" => "string",
            ],

            "is_active" => [
                "type" => "boolean",
            ]
        ], parent::filterableDetails());
    }


    protected function ownerableId($query, $param)
    {
        return $query->where("ownerable_id", $param);
    }

    protected function ownerableType($query, $param)
    {
        return $query->where("ownerable_type", $param);
    }

    protected function gatewayId($query, $param)
    {
        return $query->where("gateway_id", $param);
    }

    protected function gatewayCustomerId($query, $param)
    {
        return $query->where("gateway_customer_id", $param);
    }

    protected function isActive($query, $param)
    {
        return $query->where("is_active", $param);
    }

}