<?php

namespace MoveOn\Subscription\Requests;

use MoveOn\Subscription\Models\Plan;
use MoveOn\Subscription\Models\Subscription;

class GatewaySubscriptionDetailDTORequest extends BaseRequest
{
    public function __construct(
        public ?string $gatewayStripeSubscriptionId = null,
        public ?string $gatewayPaypalSubscriptionId = null,
    ) {
        abort_if($this->gatewayPaypalSubscriptionId && $this->gatewayStripeSubscriptionId, 422, 'Expected one subscription id given both');
        abort_if(!$this->gatewayPaypalSubscriptionId && !$this->gatewayStripeSubscriptionId, 422, 'Expected one subscription id given empty ');
    }
}