<?php

namespace MoveOn\Subscription\Requests\Modules\Paypal\Plan;

use MoveOn\Subscription\Enums\IntervalUnit;
use MoveOn\Subscription\Requests\BaseRequest;

class PlanFrequency extends  BaseRequest
{
    public function __construct(
        public IntervalUnit $interval_unit,
        public int $interval_count
    ) {
        if($this->interval_unit->value == IntervalUnit::PAYPAL_DAY() && ($this->interval_count < 1 || $this->interval_count > 365)) throw new \Exception("PlantFrequency:Paypal Interval unit and Interval count mismatch. Interval count valid in range (1,365)");
        if($this->interval_unit->value == IntervalUnit::PAYPAL_WEEK() && ($this->interval_count < 1 || $this->interval_count > 52)) throw new \Exception("PlantFrequency:Paypal Interval unit and Interval count mismatch. Interval count valid in range (1,52)");
        if($this->interval_unit->value == IntervalUnit::PAYPAL_MONTH() && ($this->interval_count < 1 || $this->interval_count > 12)) throw new \Exception("PlantFrequency:Paypal Interval unit and Interval count mismatch. Interval count valid in range (1,12)");
        if($this->interval_unit->value == IntervalUnit::PAYPAL_YEAR() && ($this->interval_count != 1)) throw new \Exception("PlantFrequency:Paypal Interval unit and Interval count mismatch. Interval count valid value only 1");
    }
}