<?php

namespace MoveOn\Subscription\Requests;

use MoveOn\Subscription\Collection\Modules\Paypal\PlanTierCollection;
use MoveOn\Subscription\Enums\IntervalUnit;
use MoveOn\Subscription\Enums\PricingScheme;
use MoveOn\Subscription\Enums\QuantitySource;
use MoveOn\Subscription\Enums\UsageType;
use MoveOn\Subscription\Models\Product;

class PlanCreateDTORequest extends BaseRequest
{
    public function __construct(
        public Product $product,
        public string $currency,
        public string $name,
        public float $unit_amount,
        public IntervalUnit $interval_unit,
        public int $interval_count,
        public UsageType $usage_type,
        public PricingScheme $pricing_scheme,
        public QuantitySource $quantity_source,
        public int $trial_period_days,
        public float $system_usage_charge,
        public PlanTierCollection $tiers,
        public bool $is_active = true,
        public int $default_quantity = 0,
        public ?string $description = null,
    ) {
    }
}