<?php

namespace MoveOn\Subscription\Traits;

use App\Models\User;
use MoveOn\Subscription\Models\Plan;
use MoveOn\Subscription\Models\Subscription;

trait WebhookPaypalSubscriptionPayloadProcessable
{
    private string $email;
    private string $plan_id;
    private string $subscription_id;

    private User $user;
    private Plan $plan;
    private Subscription $subscription;

    public function getPayload(): array
    {
        return $this->payload;
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function getPlanId(): string
    {
        return $this->plan_id;
    }

    public function getSubscriptionId(): string
    {
        return $this->subscription_id;
    }

    public function getUser(): User
    {
        if(isset($this->user) && !empty($this->user)){
            return $this->user;
        }

        $user = User::where("email", $this->getEmail())->first();

        abort_if(empty($user), 500, "User not found from given email address. payload:" . json_encode($this->payload));

        return $user;
    }

    public function getPlan(): Plan
    {
        if(isset($this->plan) && !empty($this->plan)){
            return $this->plan;
        }

        $plan = Plan::find($this->getPlanId());

        abort_if(empty($plan), 500, "Plan not found with the given palan id. payload:" . json_encode($this->payload));

        return $plan;
    }

    public function getSubscription(): Subscription
    {
        if(isset($this->subscription) && !empty($this->subscription)){
            return $this->subscription;
        }

        $subscription = Subscription::where("gateway_subscription_id", $this->getSubscriptionId())->first();

        abort_if(empty($subscription), 500, "Subscription not found with the given subscription id. payload:" . json_encode($this->payload));

        return $subscription;
    }

}